/*
 *  kexbases\other\_other_stubs.c
 *
 *  Copyright (C) 2009, Xeno86
 *  Copyright (C) 2016, jumper
 *
 *  This file is part of KernelEx source code.
 *
 *  KernelEx is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published
 *  by the Free Software Foundation; version 2 of the License.
 *
 *  KernelEx is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "common.h"

#define ERROR_NS              50L
#define ERROR_NI             120L
#define HRESULT_NI    0x80004001L
#define SEC_E_UNS     0x80090302L
#define STATUS_NI     0xC0000002L


//[Comdlg32.dll]
 se_UNIMPL_FUNC(Comdlg32_Ssync_ANSI_UNICODE_Struct_For_WOW, 3, ERROR_NI);

 
//[Crypt32.dll]
  s_UNIMPL_FUNC(Crypt32_CryptBinaryToStringAW,    5);  // 1stBrowser
 se_UNIMPL_FUNC(Crypt32_CryptStringToBinaryAW,    7, ERROR_NI);


//[Imagehlp.dll]
 se_UNIMPL_FUNC(Imagehlp_EnumerateLoadedModules64, 3, ERROR_NI);  //=f3e  ;ie8 ;in Dbghelp 5.1
 se_UNIMPL_FUNC(Imagehlp_StackWalk64,              9, ERROR_NI);  //=f9e  ;qt5
 se_UNIMPL_FUNC(Imagehlp_SymGetLineFromAddr,       4, ERROR_NI);  //=f4e  ;Dolphin3
 se_UNIMPL_FUNC(Imagehlp_SymGetSymFromAddr64,      4, ERROR_NI);  //=f4e  ;qt5


//[Imm32.dll]
  s_UNIMPL_FUNC(Imm32_ImmDisableTextFrameService, 1);  //=f1


//[Iphlpapi.dll]
  s_UNIMPL_FUNC(Iphlpapi_CancelIPChangeNotify,           1);  //=v1 #190
 rs_UNIMPL_FUNC(Iphlpapi_ConvertInterfaceLuidToGuid, 
                                      ERROR_NI, 2);  //=e2 ;Pro Evolution Soccer 2015
 rs_UNIMPL_FUNC(Iphlpapi_EnableRouter,         ERROR_NI, 2);  //=e2
 rs_UNIMPL_FUNC(Iphlpapi_FlushIpNetTable,      ERROR_NI, 1);  //=e1
 rs_UNIMPL_FUNC(Iphlpapi_GetAdaptersAddresses, ERROR_NI, 5);  //=e5
 rs_UNIMPL_FUNC(Iphlpapi_GetBestInterfaceEx,   ERROR_NI, 2);  //=e2
 rs_UNIMPL_FUNC(Iphlpapi_GetExtendedTcpTable,  ERROR_NS, 6);  //=ns6
 rs_UNIMPL_FUNC(Iphlpapi_GetExtendedUdpTable,  ERROR_NS, 6);  //=ns6
 rs_UNIMPL_FUNC(Iphlpapi_GetIpStatisticsEx,    ERROR_NS, 2);  //=ns2
 rs_UNIMPL_FUNC(Iphlpapi_GetPerAdapterInfo,    ERROR_NS, 3);  //=ns3
 rs_UNIMPL_FUNC(Iphlpapi_GetTcpStatisticsEx,   ERROR_NS, 2);  //=ns2
 rs_UNIMPL_FUNC(Iphlpapi_GetTcpTable2,         ERROR_NS, 3);  //=ns3
 rs_UNIMPL_FUNC(Iphlpapi_GetUdpStatisticsEx,   ERROR_NS, 2);  //=ns2
 se_UNIMPL_FUNC(Iphlpapi_IcmpParseReplies,               2, ERROR_NI);  //=z2e120
 se_UNIMPL_FUNC(Iphlpapi_IcmpSendEcho2,                 11, ERROR_NI);  //=z11e120 #VirtualBox 4, topic/146529:entry979723
 rs_UNIMPL_FUNC(Iphlpapi_UnenableRouter,       ERROR_NS, 2);  //=e2


//[Lz32.dll] --- including API's in modules that use KnownDLLs to forward to LZ32 ---
//;Apphelp.dll -> BWC 24d 5.01.2599.3
  s_UNIMPL_FUNC(Lz32_ApphelpCheckShellObject_no_Apphelp,    3);  //=f3 to block ;Shlwapi.IE7
 rs_UNIMPL_FUNC(Lz32_ApphelpCheckShellObject_ok_Apphelp, 1, 3);  //=o3 to okay  ;Shlwapi.IE7

//;Credui.dll
 rs_UNIMPL_FUNC(Lz32_CredUIPromptForCredentialsAW_no_Credui, 1223, 10);  //=r1223s10 ;1223=Cancel
  s_UNIMPL_FUNC(Lz32_CredUIPromptForCredentialsAW_ok_Credui,       10);  //=   r0s10 ;0=OK

//;Dbghelp.dll -> W2k IMAGEHLP.DLL 5.00.2195.6614
/*s_UNIMPL_FUNC(Lz32_MiniDumpWriteDump_Dbghelp,  7);  //=f7 ;+*/
  s_UNIMPL_FUNC(Lz32_SymFromAddr_Dbghelp,        4);  //=z4 #224
 se_UNIMPL_FUNC(Lz32_SymFunctionTableAccess64_Dbghelp, 2, ERROR_NI);  //=z2e  ;Spdf232
 se_UNIMPL_FUNC(Lz32_SymGetLineFromAddr64_Dbghelp,     4, ERROR_NI);  //=f4e  ;Spdf232
 se_UNIMPL_FUNC(Lz32_SymGetModuleBase64_Dbghelp,       2, ERROR_NI);  //=z2e  ;Spdf232
 se_UNIMPL_FUNC(Lz32_SymGetSearchPathW_Dbghelp,        3, ERROR_NI);  //=f3e  ;schwups
 se_UNIMPL_FUNC(Lz32_SymSetSearchPathW_Dbghelp,        2, ERROR_NI);  //=f2e  ;schwups

//;Dnsapi.dll -> W2k? 5.00.2195.7283
  s_UNIMPL_FUNC(Lz32_DnsFree_Dnsapi,            2);  //=v2
 rs_UNIMPL_FUNC(Lz32_DnsQuery_AW_Dnsapi,  9004, 6);  //=r9004s6 NI; 9717 DNS unavailable
  s_UNIMPL_FUNC(Lz32_DnsRecordListFree_Dnsapi,  2);  //=v2

//;Rasdlg.dll
 rs_UNIMPL_FUNC(Lz32_RasDialDlgAW_Rasdlg,     [esp+16]
   __asm push ERROR_NI __asm pop DWORD PTR[eax+24] 
   __asm push        0 __asm pop eax, 4);  //f4  p4[6]=0
 rs_UNIMPL_FUNC(Lz32_RasEntryDlgAW_Rasdlg,     [esp+12]
   __asm push ERROR_NI __asm pop DWORD PTR[eax+28] 
   __asm push        0 __asm pop eax, 4);  //f4  p3[7]=0 ;*W inetcpl.ie7
 rs_UNIMPL_FUNC(Lz32_RasPhonebookDlgAW_Rasdlg, [esp+12]
   __asm push ERROR_NI __asm pop DWORD PTR[eax+24] 
   __asm push        0 __asm pop eax, 3);  //f3  p3[6]=0

//;Sfc.dll
  s_UNIMPL_FUNC(Lz32_SfcIsFileProtected_Sfc, 2);  //=f2 ;ie7 iedw.exe

//;WindowsCodecs.dll
 rs_UNIMPL_FUNC(Lz32_WICConvertBitmapSource_WindowsCodecs, HRESULT_NI, 3);  //=h3

//;Winhttp.dll -> 5.1.2600.1557 (xpsp2_gdr.040517-1325)
 se_UNIMPL_FUNC(Lz32_WinHttpCloseHandle_Winhttp, 1, ERROR_NI);  //=f1e ; Update DLL!


//[Ole32.dll]
 rs_UNIMPL_FUNC(Ole32_CLSIDFromProgIDEx,          HRESULT_NI, 2);
 rs_UNIMPL_FUNC(Ole32_CoAllowSetForegroundWindow, HRESULT_NI, 2);
 rs_UNIMPL_FUNC(Ole32_CoGetObjectContext,         HRESULT_NI, 2);
 rs_UNIMPL_FUNC(Ole32_CoGetStdMarshalEx,          HRESULT_NI, 3);
 rs_UNIMPL_FUNC(Ole32_CoRegisterInitializeSpy,    HRESULT_NI, 2);
 rs_UNIMPL_FUNC(Ole32_CoRevokeInitializeSpy,      HRESULT_NI, 1);


//[OpenGL32.dll]
 rs_UNIMPL_FUNC(OpenGL32_wglSwapMultipleBuffers, ERROR_NI, 2);  //= ** ;loblo


//[Powrprof.dll]
 rs_UNIMPL_FUNC(Powrprof_CanUserWritePwrScheme,   1, 0);  //=o0 #227?


//[Rasapi32.dll]
 rs_UNIMPL_FUNC(Rasapi32_DwEnumEntryDetails,     -1, 4);  //=t4? ;iphlpapi.2k
 rs_UNIMPL_FUNC(Rasapi32_RasGetAutodialAddressW, -1, 5);  //=t5 ;SM2.9.1
 rs_UNIMPL_FUNC(Rasapi32_RasGetAutodialEnableW,  -1, 2);  //=t2 ;SM2.9.1
 rs_UNIMPL_FUNC(Rasapi32_RasGetAutodialParamW,   -1, 3);  //=t3 ;SM2.9.1
 rs_UNIMPL_FUNC(Rasapi32_RasSetAutodialAddressW, -1, 5);  //=t5 ;SM2.9.1


//[Rpcrt4.dll]
 rs_UNIMPL_FUNC(Rpcrt4_I_RpcAsyncAbortCall, STATUS_NI, 2);
 rs_UNIMPL_FUNC(Rpcrt4_I_RpcAsyncSetHandle, STATUS_NI, 2);
 rs_UNIMPL_FUNC(Rpcrt4_I_RpcBindingInqLocalClientPID, STATUS_NI, 2);
 rs_UNIMPL_FUNC(Rpcrt4_I_RpcExceptionFilter, STATUS_NI, 1);
 rs_UNIMPL_FUNC(Rpcrt4_I_RpcGetBufferWithObject, STATUS_NI, 2);

 rs_UNIMPL_FUNC(Rpcrt4_NdrAsyncClientCall, STATUS_NI, 1);
 rs_UNIMPL_FUNC(Rpcrt4_NdrDcomAsyncClientCall, STATUS_NI, 1);
 rs_UNIMPL_FUNC(Rpcrt4_NdrGetUserMarshalInfo, STATUS_NI, 3);
 rs_UNIMPL_FUNC(Rpcrt4_NdrMesTypeAlignSize2, STATUS_NI, 5);
 rs_UNIMPL_FUNC(Rpcrt4_NdrMesTypeDecode2, STATUS_NI, 5);
 rs_UNIMPL_FUNC(Rpcrt4_NdrMesTypeEncode2, STATUS_NI, 5);

 rs_UNIMPL_FUNC(Rpcrt4_RpcAsyncCancelCall, STATUS_NI, 2);
 rs_UNIMPL_FUNC(Rpcrt4_RpcAsyncCompleteCall, STATUS_NI, 2);
 rs_UNIMPL_FUNC(Rpcrt4_RpcAsyncGetCallStatus, STATUS_NI, 1);
 rs_UNIMPL_FUNC(Rpcrt4_RpcAsyncInitializeHandle, STATUS_NI, 2);
 rs_UNIMPL_FUNC(Rpcrt4_RpcCancelThreadEx, STATUS_NI, 2);
 rs_UNIMPL_FUNC(Rpcrt4_RpcCertGeneratePrincipalNameW, STATUS_NI, 3);
 rs_UNIMPL_FUNC(Rpcrt4_RpcServerInqCallAttributesW, STATUS_NI, 2);
 rs_UNIMPL_FUNC(Rpcrt4_RpcServerRegisterIf2, STATUS_NI, 7);
 rs_UNIMPL_FUNC(Rpcrt4_RpcServerTestCancel, STATUS_NI, 1);
 rs_UNIMPL_FUNC(Rpcrt4_RpcServerUnregisterIfEx, STATUS_NI, 3);
 rs_UNIMPL_FUNC(Rpcrt4_RpcTestCancel, STATUS_NI, 0);


//[Secur32.dll]
 rs_UNIMPL_FUNC(Secur32_DecryptMessage,                 -1,        4);  //=t4
 rs_UNIMPL_FUNC(Secur32_EncryptMessage,                 -1,        4);  //=t4
 se_UNIMPL_FUNC(Secur32_GetComputerObjectNameW,          3, ERROR_NI);  //=z3e120
 se_UNIMPL_FUNC(Secur32_GetUserNameExAW,                 3, ERROR_NI);  //=z3e #45
 rs_UNIMPL_FUNC(Secur32_LsaCallAuthenticationPackage,   STATUS_NI, 7);  //=n7
 rs_UNIMPL_FUNC(Secur32_LsaConnectUntrusted,            STATUS_NI, 1);  //=n1
 rs_UNIMPL_FUNC(Secur32_LsaEnumerateLogonSessions,      STATUS_NI, 2);  //=t2 #45
 rs_UNIMPL_FUNC(Secur32_LsaFreeReturnBuffer,            STATUS_NI, 1);  //=t1 #45
 rs_UNIMPL_FUNC(Secur32_LsaGetLogonSessionData,         STATUS_NI, 2);  //=t2 #45
 rs_UNIMPL_FUNC(Secur32_LsaLookupAuthenticationPackage, STATUS_NI, 3);  //=n3

/*
 rs_UNIMPL_FUNC(Secur32_AcquireCredentialsHandleW,      SEC_E_UNS, 9);  //Opera.dll 12.18
 rs_UNIMPL_FUNC(Secur32_CompleteAuthToken,              STATUS_NI, 2);  //=n2 ;Chrome.dll
 rs_UNIMPL_FUNC(Secur32_EnumerateSecurityPackagesW,     SEC_E_UNS, 2);
 rs_UNIMPL_FUNC(Secur32_InitializeSecurityContextW,     SEC_E_UNS, 12);
 rs_UNIMPL_FUNC(Secur32_QueryContextAttributesW,        SEC_E_UNS, 3);
 rs_UNIMPL_FUNC(Secur32_QueryCredentialsAttributesW,    SEC_E_UNS, 9);
 rs_UNIMPL_FUNC(Secur32_QuerySecurityPackageInfoW,      SEC_E_UNS, 2);  //Chrome.dll
 */

//[Shlwapi.dll]
 rs_UNIMPL_FUNC(Shlwapi_AssocGetPerceivedType,  HRESULT_NI, 4); //ie7
 rs_UNIMPL_FUNC(Shlwapi_AssocGetUrlAction,          0x1808, 1);
  s_UNIMPL_FUNC(Shlwapi_AssocIsDangerous,                   1); //ie7
 rs_UNIMPL_FUNC(Shlwapi_ParseURLW,              HRESULT_NI, 2); //r0x80004001s2 ** #ROS1406 urlmon
  s_UNIMPL_FUNC(Shlwapi_PathUnExpandEnvStringsAW,           3); //f3 fail ;A ie8 ;W notepad2 4.2.25
 rs_UNIMPL_FUNC(Shlwapi_SHCreateStreamOnFileEx,  STATUS_NI, 6); //r0xC0000002s6 ;ie8
 rs_UNIMPL_FUNC(Shlwapi_SHRegGetPathW,            ERROR_NI, 5); //r120s5 ;Safari.dll 7536.30.1.0 (Safari 605)
 rs_UNIMPL_FUNC(Shlwapi_SHRegGetValueAW,                -1, 7); //t7 ;A ie8  ;W Mshtml.IE7
 rs_UNIMPL_FUNC(Shlwapi_SHRegSetPathW,            ERROR_NI, 5); //e5 ;Shimgvw.xp
 rs_UNIMPL_FUNC(Shlwapi_SHReleaseThreadRef,     HRESULT_NI, 0); //h0 ;Shimgvw.xp
  s_UNIMPL_FUNC(Shlwapi_StrToInt64ExAW,                     3); //z3 ;ie8
 rs_UNIMPL_FUNC(Shlwapi_467,                    HRESULT_NI, 2); ////467= ;urlmon.ie7


//[T2embed.dll] ;E_NONE 0x0000L, E_API_NOTIMPL 0x0001L
 rs_UNIMPL_FUNC(T2embed_TTEmbedFontEx,          1, 11);  //=o11
 rs_UNIMPL_FUNC(T2embed_TTGetNewFontName,       1,  5);  //=o5
 rs_UNIMPL_FUNC(T2embed_TTRunValidationTestsEx, 1,  2);  //=o2


//[Winspool.drv]
 rs_UNIMPL_FUNC(Winspool_GetPrinterDataExAW,  ERROR_NI, 7);
 se_UNIMPL_FUNC(Winspool_IsValidDevmodeW,               2, ERROR_NI);
 rs_UNIMPL_FUNC(Winspool_SetPrinterDataExAW,  ERROR_NI, 6);
 se_UNIMPL_FUNC(Winspool_XcvDataW,                      8, ERROR_NI);
